/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.system;

import com.ibm.hwmca.base.hmcservc.HmcServicesData;
import com.ibm.hwmca.base.settings.network.FirewallAdmin;
import com.ibm.hwmca.base.settings.network.FirewallAdminException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.task.TaskErrorIds;
import com.ibm.hwmca.fw.tasklet.Tasklet;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.util.ManagePersistedObjects;
import com.ibm.hwmca.fw.util.Trace;

public class KeepAliveTasklet
extends Tasklet
implements TaskErrorIds {
    private static final String TRACE_MASKT = "XFRMLCTT";
    private static final String TRACE_MASKF = "XFRMLCTF";
    private static final String TRACE_MASKD = "XFRMLCTD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "KeepAlvTlet");
    private static Object shutdownLock = new Object();
    public static Tasklet tasklet = null;
    private static boolean shutdownReceived = false;
    private static int exitStatus = 0;

    public KeepAliveTasklet() {
        Trace.trace(TRACE_MASKT, "<> KeepAliveTasklet ctor");
        tasklet = this;
    }

    public void init(Object o) {
        Trace.trace(TRACE_MASKT, "<> KeepAliveTasklet.init(o)");
    }

    public void service(TaskletRequest taskletRequest, TaskletResponse taskletResponse) throws TaskletException {
        block5: {
            Trace.trace(TRACE_MASKT, "-> KeepAliveTasklet.service()");
            try {
                if (!taskletRequest.isInitialRequest()) break block5;
                Trace.trace(TRACE_MASKF, "it is the initial request");
                if (HmcServicesData.getHmcServicesData().isRemoteOperationEnabled()) {
                    ManagePersistedObjects.waitForRestore();
                    try {
                        FirewallAdmin.getFirewallAdmin().enableWebPorts();
                    }
                    catch (FirewallAdminException e) {
                        Trace.trace(TRACE_MASKF, e);
                        this.logException(e);
                    }
                }
                this.waitForShutdown(taskletResponse);
            }
            catch (Exception e) {
                this.logException(e);
            }
        }
        Trace.trace(TRACE_MASKT, "<- KeepAliveTasklet.service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> KeepAliveTasklet.logException()");
        Trace.trace(TRACE_MASKT, "processing exception: " + throwable);
        new FrameworkLog(classLogInfo, 61, throwable).log();
        Trace.trace(TRACE_MASKT, "<- KeepAliveTasklet.logException()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForShutdown(TaskletResponse taskletResponse) {
        Trace.trace(TRACE_MASKF, "-> KeepAliveTasklet.waitForShutdown()");
        Object object = shutdownLock;
        synchronized (object) {
            shutdownReceived = false;
            while (!shutdownReceived) {
                try {
                    shutdownLock.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            Trace.trace(TRACE_MASKF, "KeepAliveTasklet: shutdown request received");
            taskletResponse.setData("RC", new Integer(exitStatus));
            taskletResponse.noAction();
        }
        Trace.trace(TRACE_MASKF, "<- KeepAliveTasklet.waitForShutdown()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownLocalClient(int shutdownType, int exitStatus) {
        Trace.trace(TRACE_MASKF, "-> KeepAliveTasklet.shutdownLocalClient()");
        Object object = shutdownLock;
        synchronized (object) {
            shutdownReceived = true;
            KeepAliveTasklet.exitStatus = exitStatus;
            shutdownLock.notifyAll();
        }
        Trace.trace(TRACE_MASKF, "<- KeepAliveTasklet.shutdownLocalClient()");
    }
}

